/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.transfer.callbacks;

import io.github.fabricators_of_create.porting_lib.transfer.callbacks.TransactionFailCallback;
import io.github.fabricators_of_create.porting_lib.transfer.callbacks.TransactionSuccessCallback;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;

public abstract class TransactionCallback
implements TransactionContext.CloseCallback {
    protected final List<Runnable> callbacks = new ArrayList<Runnable>();
    protected boolean failed = false;

    public TransactionCallback(TransactionContext ctx) {
        ctx.addCloseCallback((TransactionContext.CloseCallback)this);
    }

    public TransactionCallback(TransactionContext ctx, Runnable callback) {
        this(ctx);
        this.addCallback(callback);
    }

    public TransactionCallback addCallback(Runnable callback) {
        this.callbacks.add(callback);
        return this;
    }

    protected abstract boolean shouldRunCallbacks();

    public void onClose(TransactionContext transaction, TransactionContext.Result result) {
        this.failed |= result.wasAborted();
        if (transaction.nestingDepth() == 0) {
            if (this.shouldRunCallbacks()) {
                ListIterator<Runnable> itr = this.callbacks.listIterator();
                while (itr.hasNext()) {
                    Runnable callback = itr.next();
                    callback.run();
                    itr.remove();
                }
            }
        } else {
            transaction.getOpenTransaction(transaction.nestingDepth() - 1).addCloseCallback((TransactionContext.CloseCallback)this);
        }
    }

    public static TransactionSuccessCallback onSuccess(TransactionContext ctx, Runnable r) {
        return new TransactionSuccessCallback(ctx, r);
    }

    public static TransactionFailCallback onFail(TransactionContext ctx, Runnable r) {
        return new TransactionFailCallback(ctx, r);
    }
}

